<!-- This template is used for proposing changes to the left sidebar contextual navigation. This could include additions, removals, or general changes to overall hierarchy.-->

# Summary

_Please summarize the navigation changes you are hoping to make._

# Background

<!-- Use this section to explain the proposed changes, including details around usage and business drivers. -->

Link to epic / issue with overall feature proposal: _issue link_

Does this navigation proposal facilitate one of our primary JTBDs? Which job?


How does this change improve the workflow for users attempting to complete that job?


How many users will be impacted by this proposed change?

- [ ] Limited
- [ ] Moderate
- [ ] All users

What is the product maturity stage of the associated feature?

- [ ] Experimental
- [ ] Beta
- [ ] General availability

How often do you expect an average GitLab user (_not_ just your target persona) to reach for this functionality?

- [ ] Several times a day
- [ ] Once a day
- [ ] A few times a week
- [ ] Once a week
- [ ] Less than once a week

# Approaches considered

_Please describe the alternative designs you considered._

# Justification

_Provide your justification for this change. See https://handbook.gitlab.com/handbook/product/ux/navigation/ for the minimum validation we request based on the scope of access of your proposed change._

# Review checklist

#### Requester

- [ ] Review the [handbook page for navigation](https://handbook.gitlab.com/handbook/product/ux/navigation/).
- [ ] Add relevant information to the issue description detailing your proposal, including usage and business drivers.
- [ ] List at least two other places you considered to introduce your feature.
- [ ] Add relevant designs to the Design Management area of the issue.
- [ ] Ensure your UI suggestion align with the [Documentation Style Guide](https://docs.gitlab.com/ee/development/documentation/styleguide/).
- [ ] Engage ~"Technical Writing". They can help craft a term that best describes the feature(s) you’re proposing. 
- [ ] Follow the [product development workflow](https://handbook.gitlab.com/handbook/product-development-flow/#validation-phase-2-problem-validation) validation process to ensure you are solving a well understood problem and that the proposed change is understandable and non-disruptive to users. Navigation-specific research is mandatory for additions or when restructuring.
- [ ] Engage the [Foundations Product Manager](https://handbook.gitlab.com/handbook/product/categories/#foundations-group) for approval. The Foundations DRI (@jtucker_gl) will work with UX partners in product design, research, and technical writing, as applicable.
- [ ] Consider whether you need to [communicate the change somehow](https://design.gitlab.com/patterns/navigation#messaging-changes-to-users), or if you will have an interim period in the UI where your item will live in more than one place.
- [ ] Ensure engineers are familiar with the [implementation steps for navigation](https://docs.gitlab.com/development/navigation_sidebar/#navigation-sidebar).

#### Foundations Product Manager

- [ ] Confirm proposal has necessary information
- [ ] Schedule design review for next milestone

#### Foundations Product Designer

- [ ] Confirm Pajamas guidelines are followed
- [ ] Confirm a11y needs are addressed
- [ ] Confirm burden of proof supplied for stated scope of access

/label ~UX ~"UI text" ~"documentation" ~"Category:Navigation & Settings"  ~navigation ~type::ignore
/label ~"Nav request::Start"  